import numpy as np
import pylab as pl
import scipy as sc
from matplotlib_defaults import fig_width, cm2inch
from mpldatacursor import datacursor


# Version features: +Plots averaged, normalised conductances over settable no. of samples. - Normalisation rules changed to range of AVERAGED data.
#                   +Plots neuron fire count for different categories of input (pattern 0, pattern 1, patterns different from pat 1 in 1 location, ...)


# # # # # # # # # # # # 
# # # # P A R A M # # #
# # # # # # # # # # # # 

SAVE = True                         # Save the figure?
ZOOM = 1.0                          # Zooming factor on display (not for savefig!)
# select the panels to plot ("weight", "membrane", "response")
PANEL = ("weight", "fireprob", "response", "nweight", "membrane") #Valid tags: weight, membrane, response, FFT, fireprob

#User-defined input.
path = "data/ANN runs/"
inname = raw_input("Enter filename: ") # user input filename.

# Set output filename
fname = path + inname[:-3] + "npz"			# Clear file extension given by user and use .npz instead.

k_memristor = 0                     # Neuron index with afferent memristor synapses
k_software = 1                      # Neuron index with afferent software synapses
reference_pattern = ((1,0,0,1),     # Patterns for membrane potential calculation 
                     (0,1,1,0))

#Colour maps:
pattern_color = ('g', 'darkmagenta', 'LimeGreen', 'Violet')          # Colours mapped to patterns and neurons (1001 hard, 0110 hard, 1001 soft, 0110 soft)
neuron_cols = ('orange', 'turquoise') #Colours for neurons (hardware, software)

resp_T = 41                         # num response patterns (at beginning and end respectively)


# # # # # # # # # # # # # #
# E N D   O F   P A R A M #
# # # # # # # # # # # # # #

# Zooming
pl.rc('figure', dpi=pl.rcParams['figure.dpi'] * ZOOM)

# SETUP FIGURE AND AXES
pl.interactive(False)
fig = pl.figure(figsize=(fig_width['two_col'], cm2inch(10.)))
axes = dict()

# membrane potential
rect = 0.10, 0.84, 0.81, 0.12
ax = fig.add_axes(rect, aspect='auto', xticks=[])
axes['vmem'] = ax
# weights
rect = 0.10, 0.84-0.16, 0.81, 0.16
ax = fig.add_axes(rect, aspect='auto')
axes['weight'] = ax
# weights color bar
rect = 0.925, 0.84-0.16, 0.015, 0.16
ax = fig.add_axes(rect, aspect='auto', xticks=[], yticks=[])
axes['weight_cb'] = ax
# normalised weights
rect = 0.10, 0.84-0.36, 0.81, 0.16
ax = fig.add_axes(rect, aspect='auto')
axes['nweight'] = ax
# normalised weights color bar
rect = 0.925, 0.84-0.36, 0.015, 0.16
ax = fig.add_axes(rect, aspect='auto', xticks=[], yticks=[])
axes['nweight_cb'] = ax
# response at beginning
rect = 0.07, 0.10, 0.45-0.07, 0.25
ax = fig.add_axes(rect, aspect='auto')
axes['resp_begin'] = ax
# response at end
rect = 0.97-(0.45-0.07), 0.10, 0.45-0.07, 0.25
ax = fig.add_axes(rect, aspect='auto')
axes['resp_end'] = ax
# Labels
rect = 0.0001, 0.0001, 0.9998, 0.9998
ax = fig.add_axes(rect, aspect='auto', frame_on=False, xticks=[], yticks=[])
axes['label'] = ax

# SET LABELS
labels = dict(A=(0.02,0.95), B=(0.02,0.83), C=(0.02, 0.63), D=(0.02,0.35), E=(0.54,0.35))
for s,(x,y) in labels.iteritems():
    axes['label'].text(x, y, s, weight='bold', size=10, ha='center', va='baseline')

# LOAD DATA AND ADD TO MAIN NAMESPACE
print " > Load data from '%s'." % fname
x = np.load(fname)
s = " > Adding to main name space: "
for k in x.keys():
    globals()[k] = x[k]
    s += k + "  "
print s



# # # # # # # # #
# PANEL: WEIGHT #
# # # # # # # # #

if "weight" in PANEL:
    ax = axes['weight']
    # weights
    v = V.reshape(T,K*N)
    vmin, vmax = -abs(v).max(), abs(v).max()
    weighthist = np.asarray(v)
    print(weighthist[:,0].max())
    print(weighthist[:,0].min())
    print(weighthist[:,1].max())
    print(weighthist[:,1].min())
    print(weighthist[:,2].max())
    print(weighthist[:,2].min())
    print(weighthist[:,3].max())
    print(weighthist[:,3].min())
    kwargs = dict(origin='lower', interpolation='nearest', cmap=pl.cm.RdBu_r, aspect='auto')
    im = ax.imshow(v.T, vmin=vmin, vmax=vmax, **kwargs) #Plot data.
    ax.set_xlabel("Time [trial number]")
    ax.set_yticks(range(0,K*N,N))
    ax.set_ylabel("Synapse", labelpad=8)
    # colorbar
    weight_cb = pl.colorbar(im, cax=axes['weight_cb'])
    cmin, cmax = np.round(weight_cb.get_clim(), decimals=0)
    cticks = np.arange(cmin, cmax, 1)
    weight_cb.set_ticks(cticks)
    weight_cb.set_label("Weight")
    # frame around memristor weights
    eps_x, eps_y = 0.5, 0.05
    xy = -0.5 + eps_x,  k_memristor * N - 0.5 + eps_y #Location of rectangle to be plotted.
    w,h = T - 2 * eps_x,  N - 2 * eps_y #Width and height of rectangle to be plotted.
    kwargs = dict(fc='none', ec='k', ls='solid', lw=1.5)
    patch = pl.Rectangle(xy, w, h, **kwargs)
    ax.add_patch(patch)


# # # # # # # # # # # # # #
# PANEL: AVERAGED WEIGHT  #
# # # # # # # # # # # # # #

if "nweight" in PANEL:
    ax = axes['nweight'] #Get handle to normalised weight axes.
    # Weights.
    v = V.reshape(T, K*N)
    KERN = 50 #Average over how many samples?
    KERN = input("Average over how many samples? (No of samples 'above and below' current * 2): ")
    print("Average taken over: ", 2*round(KERN/2)+1, "samples.")

    varr = np.asarray(v) #End up with varr[event no.][synapse ID] - weight matrix over trials.
    varrn = varr*0 #Define normalised weight array.
    
    for n in range(K*N):
        for o in range(len(v)):
            #varrn[o,n] = (sum(v[max(0,o-round(KERN/2)) : min(o+round(KERN/2)+1,len(v)), n])/(2*round(KERN/2)+1) - varr[:,n].min())/(varr[:,n].max() - varr[:,n].min())
            varrn[o,n] = sum(v[max(0,o-round(KERN/2)) : min(o+round(KERN/2)+1,len(v)), n])/(2*round(KERN/2)+1)
            #Create moving average weigh matrix - unnormalised.
            #+1 to make sure equal no. of samples taken around 'current' sample.

        #Normalise weights.
        #print(varrn[:,n].max() - varrn[:,n].min())
        varrn[:,n] -= varrn[:,n].min()
        varrn[:,n] /= (varrn[:,n].max() - varrn[:,n].min())
        #varrn[:,n] = (varrn[:,n] - varr[:,n].min())/(varrn[:,n].max() - varrn[:,n].min())
        #print(varrn[:,n].max() - varrn[:,n].min())

    #Now show plot.

    kwargs = dict(origin='lower', interpolation='nearest', cmap=pl.cm.RdBu_r, aspect='auto')
    im = ax.imshow(varrn.T.tolist(), vmin=0, vmax=1, **kwargs) #Plot data.
    ax.set_xlabel("Time [trial number]")
    ax.set_yticks(range(0,K*N,N))
    ax.set_ylabel("Synapse", labelpad=8)

    # Colourbar: common to all traces since always between 0 and 1.
    weight_cb = pl.colorbar(im, cax=axes['nweight_cb'])
    cmin, cmax = np.round(weight_cb.get_clim(), decimals=1)
    cticks = np.arange(cmin, cmax, 1)
    weight_cb.set_ticks(cticks)
    weight_cb.set_label("Weight")


# # # # # # # # # # # # #
# PANEL: SPECIALISATION #
# # # # # # # # # # # # #

if "fireprob" in PANEL:
    ax = axes['vmem']
    # calculate the potentials
    nPat = len(reference_pattern)
    u = np.zeros((T,nPat))                   # hardware synapse neuron membrane potential w/o biases, no homoeostasis.
    us = np.zeros((T,nPat))                   # software synapse neuron membrane potential w/o biases, no homoeostasis.
    mempot = np.zeros((T,nPat))                   # membrane potential with biases: mempot[:][0] -> green, 1001, mempot[:][1] -> purple, 0110
    mempots = np.zeros((T,nPat))                   # membrane potential with biases: mempot[:][0] -> green, 1001, mempot[:][1] -> purple, 0110
    fprob = np.zeros((K,T,nPat))            #Firing probability of neuron K at time T to pattern nPat.
    color = pattern_color
    dashes = (1,1)
    for j,pat in enumerate(reference_pattern):
        u[:,j] = [np.dot(V[t,k_memristor], pat) for t in xrange(T)] #Compute membrane potentials in response to each patterm for both hard/soft synapse neurons.
        us[:,j] = [np.dot(V[t,k_software], pat) for t in xrange(T)]
        # introduce homoeostatic biases
        mempot[:,j] = u[:,j] + B[:,k_memristor] #Capture full membrane potential including homeostatic bias.
        mempots[:,j] = us[:,j] + B[:,k_software] #Capture full membrane potential including homeostatic bias.
        # compute firing probabilities
        fprob[0,:,j] = np.exp(mempot[:,j])/(np.exp(mempot[:,j]) + np.exp(mempots[:,j]))
        fprob[1,:,j] = np.exp(mempots[:,j])/(np.exp(mempot[:,j]) + np.exp(mempots[:,j]))

    #Plot
    ax.plot(xrange(T), fprob[0,:,0]-fprob[0,:,1], neuron_cols[0]) #Plot specialisation: prob. of firing to 1001 - prob. of firing to 0110.
    ax.plot(xrange(T), fprob[1,:,0]-fprob[1,:,1], neuron_cols[1])

    # adjust axes
    ymin, ymax = ax.yaxis.get_data_interval()
    delta = 0.07 * (ymax - ymin)
    ax.set_ylim(ymin-delta, ymax+delta)
    ymin, ymax = np.round(ax.get_ylim(), decimals=0)
    #yticks = np.arange(ymin, ymax, 2)
    #ax.set_yticks(yticks)
    ax.set_yticks([-1, 0, 1])
    ax.set_ylabel("S", labelpad=3)
    ax.set_xlim(-0.5, T-0.5)


# # # # # # # # # #
# PANEL: RESPONSE #
# # # # # # # # # #

# define custom colormap
r0,g0,b0 = pl.matplotlib.colors.colorConverter.to_rgb(pattern_color[0])
r1,g1,b1 = pl.matplotlib.colors.colorConverter.to_rgb(pattern_color[1])
cdict = {'red':   ((0.0, r0, r0),
                   (0.5, 0.7, 0.7),
                   (1.0, r1, r1)),
         'green': ((0.0, g0, g0),
                   (0.5, 0.7, 0.7),
                   (1.0, g1, g1)),
         'blue':  ((0.0, b0, b0),
                   (0.5, 0.7, 0.7),
                   (1.0, b1, b1))}
my_cmap = pl.matplotlib.colors.LinearSegmentedColormap('My cmap', cdict)


if "response" in PANEL:
    # difference pattern to project on
    pat = np.array(reference_pattern[1], dtype=float) - reference_pattern[0] #Reference pattern is the difference between...
    #... pre-determined input patterns.
    # BEGIN
    ax = axes['resp_begin']
    # color code the input as background
    bgcolor = np.dot(Y[:resp_T], pat) #Background colour set based on dot product between ref. pattern and current pat.
    extent = (-0.5,resp_T-0.5, -2, K+1)
    vmax = abs(bgcolor).max()
    kwargs = dict(origin='lower', interpolation='nearest', cmap=my_cmap, aspect='auto', alpha=0.7)
    ax.imshow(bgcolor.reshape(1,resp_T), vmin=-vmax, vmax=vmax, extent=extent, **kwargs)
    x = np.arange(resp_T)
    y = Z[:resp_T]
    ax.plot(x, y, 'k|', ms=10., mew=1.5)
    ax.set_xlim(-0.5, resp_T-0.5)
    ax.set_xlabel("Time")
    ax.set_yticks(np.arange(0,K))
    ax.set_ylim(-0.5, K-0.5)
    ax.set_ylabel("Neuron")
    ax.set_title("Response at begin")
    # END
    ax = axes['resp_end']
    # color code the input as background
    bgcolor = np.dot(Y[-resp_T:], pat)
    extent = (T-resp_T-0.5, T-0.5, -2, K+1)
    vmax = abs(bgcolor).max()
    ax.imshow(bgcolor.reshape(1,resp_T), vmin=-vmax, vmax=vmax, extent=extent, **kwargs)
    x = np.arange(T-resp_T, T)
    y = Z[-resp_T:]
    ax.plot(x, y, 'k|', ms=10., mew=1.5)
    ax.set_xlim(T-resp_T-0.5, T-0.5)
    ax.set_xlabel("Time")
    ax.set_yticks(np.arange(0,K))
    ax.set_ylim(-0.5, K-0.5)
    ax.set_ylabel("Neuron")
    ax.set_title("Response at end")



# # # # # # # # # # #
# # # FIGURE 2  # # #
# # # # # # # # # # #

# Set-up figure.
fig2 = pl.figure(figsize=(3.5,2.5))

# Set-up variables and parameters.
cat = np.array([[0, 0]]*4) # 8 categories of output from the system covering which neuron wins for each prototype pattern and input...
#...patterns different from the prototypes by 1. Indices [x,y]: x = input pattern identifier. y = which neuron wins.
barwidth = 0.35

# Set-up axes

#For beginning response.
rect = 0.05, 0.15, 0.4, 0.8
ax = fig2.add_axes(rect, aspect='auto')
axes['resp_begin_bar'] = ax

#For end response.
rect = 0.55, 0.15, 0.4, 0.8
ax = fig2.add_axes(rect, aspect='auto')
axes['resp_end_bar'] = ax


# Vector holding generated patterns: resp_T
# Vector holding responses: Z
#print(Y[:resp_T])
#print('---')
#print(Y[T-resp_T:])

### RESPONSE AT BEGIN DATA CAPTURE AND PLOTTING ###

for j, sample in enumerate(Y[:resp_T]): # Use 'enumerate' to get both index and value from list being accessed.
    diffvec = sum(np.transpose(np.logical_xor(sample,reference_pattern))) # XOR actual pattern at each time T with reference pattern vector. Then...
    #...transpose the resulting vector of XORed samples and sum each XORed sample to get a measure of difference between sample and reference patterns.
    #print(sample, diffvec, Z[j]) #Show difference between input pattern and each reference pattern.

    # Check differences from each test pattern (ONLY WORKS FOR 2 PATTERNS AT THE MOMENT!")
    if diffvec[0] == 0:
        #print("Match to pattern ", reference_pattern[0])
        if Z[j] == 0:
            cat[0][0] += 1 # Pattern 0 (green), neuron 0 wins.
        else:
            cat[0][1] += 1 # Pattern 0 (green), neuron 1 wins.


    if diffvec[0] == 1:
        #print("1 different from ", reference_pattern[0])
        if Z[j] == 0:
            cat[1][0] += 1 # Different from pattern 0 by 1 (light green), neuron 0 wins.
        else:
            cat[1][1] += 1 # Different from pattern 0 by 1 (light green), neuron 1 wins.


    if diffvec[1] == 1:
        #print("1 different from ", reference_pattern[1])
        if Z[j] == 0:
            cat[2][0] += 1 # Different from pattern 1 by 1 (light purple), neuron 0 wins.
        else:
            cat[2][1] += 1 # Different from pattern 1 by 1 (light purple), neuron 1 wins.

    if diffvec[1] == 0:
        #print("Match to pattern ", reference_pattern[1])
        if Z[j] == 0:
            cat[3][0] += 1 # Pattern 1 (purple), neuron 0 wins.
        else:
            cat[3][1] += 1 # Pattern 1 (purple), neuron 1 wins.

    #print('...')

#Register highest no. of occurrences in a single category.
maxstart = np.amax(cat)

pattern_lib = ['1001','1001$\delta$','0110$\delta$','0110']
ax = axes['resp_begin_bar']
x0 = np.arange(len(cat[:,0]))
startbar0 = ax.bar(x0, cat[:,0], barwidth, color=neuron_cols[0], label='0 wins') # Bar showing how often neuron 0 wins in 4 pattern type cases.
startbar1 = ax.bar(x0+barwidth, cat[:,1], barwidth, color=neuron_cols[1], label='1 wins') # How often neuron 1 wins in 4 pattern type cases.
ax.set_xticks(x0+barwidth)
ax.set_xticklabels(pattern_lib, rotation=45)
ax.legend((startbar0, startbar1),('Hard', 'Soft'))



### RESPONSE AT END DATA CAPTURE AND PLOTTING ###

cat = np.array([[0, 0]]*4) # Reset cat array.

for j, sample in enumerate(Y[-resp_T:]): # Use 'enumerate' to get both index and value from list being accessed.
    diffvec = sum(np.transpose(np.logical_xor(sample,reference_pattern))) # XOR actual pattern at each time T with reference pattern vector. Then...
    #...transpose the resulting vector of XORed samples and sum each XORed sample to get a measure of difference between sample and reference patterns.
    print(sample, diffvec, Z[j-resp_T]) #Show difference between input pattern and each reference pattern.

    # Check differences from each test pattern (ONLY WORKS FOR 2 PATTERNS AT THE MOMENT!")
    if diffvec[0] == 0:
        #print("Match to pattern ", reference_pattern[0])
        if Z[j-resp_T] == 0:
            cat[0][0] += 1 # Pattern 0 (green), neuron 0 wins.
        else:
            cat[0][1] += 1 # Pattern 0 (green), neuron 1 wins.


    if diffvec[0] == 1:
        #print("1 different from ", reference_pattern[0])
        if Z[j-resp_T] == 0:
            cat[1][0] += 1 # Different from pattern 0 by 1 (light green), neuron 0 wins.
        else:
            cat[1][1] += 1 # Different from pattern 0 by 1 (light green), neuron 1 wins.

    if diffvec[1] == 1:
        #print("1 different from ", reference_pattern[1])
        if Z[j-resp_T] == 0:
            cat[2][0] += 1 # Different from pattern 1 by 1 (light purple), neuron 0 wins.
        else:
            cat[2][1] += 1 # Different from pattern 1 by 1 (light purple), neuron 1 wins.


    if diffvec[1] == 0:
        #print("Match to pattern ", reference_pattern[1])
        if Z[j-resp_T] == 0:
            cat[3][0] += 1 # Pattern 1 (purple), neuron 0 wins.
        else:
            cat[3][1] += 1 # Pattern 1 (purple), neuron 1 wins.

    #print('...')

#Register highest no. of occurrences in a single category.
maxend = np.amax(cat)

ax = axes['resp_end_bar']
endbar0 = ax.bar(x0, cat[:,0], barwidth, color=neuron_cols[0], label='0 wins')
endbar0 = ax.bar(x0+barwidth, cat[:,1], barwidth, color=neuron_cols[1], label='1 wins')
ax.set_xticks(x0+barwidth)
ax.set_xticklabels(pattern_lib, rotation=45)
ax.legend((startbar0, startbar1),('Hard', 'Soft'))

# set axis limits.
ax = axes['resp_begin_bar']
ax.set_ylim(0, max(maxstart,maxend))

ax = axes['resp_end_bar']
ax.set_ylim(0, max(maxstart,maxend))


#####################################################
# 2nd figure for plotting other useful information. #
#####################################################
fig2 = pl.figure(figsize=(fig_width['two_col'], cm2inch(10.)))
rect = (0.08, 0.17, 0.85, 0.75)
ax = fig2.add_axes(rect, aspect='auto')

### Fitting to suitable function. ###

#Module imports.
from scipy.optimize import leastsq

#Plot colour list.
#col = ['b', 'r', 'g', 'm', 'k', '#006699', '#ff9900', '#ff66ff']
col = ['b', 'r', 'g', 'k', 'skyblue', 'lightsalmon', 'limegreen', 'silver']


data = v.T[0,:] #By default load time evolution of synapse weight for syn. #0 into <data>.
xdat = np.array(range(0, len(v.T[0,:]), 1)) #Capture x-data (simply event indices).

#fitfunc = lambda param, xval: param[0] + xval*param[1] + (xval**2)*param[2] #Fitting function: 2nd order poly.
fitfunc = lambda param, xval: param[0]*np.exp(-xval/param[1]) + param[2]
residfunc = lambda param, xval: data - fitfunc(param,xval)
#fitguess = np.array([0.0, 0.0, 0.0]) #Initial guess for fitting - poly2.
fitguess = np.array([0.0, 1.0, 0.0]) #Initial guess for fitting - simple exponential.

#Initialise fitting container and perform fitting.
fitsyn = np.array([[0.0]*len(fitguess)]*8) #8: Number of synapses in the system.

for i in range(0, len(v.T[:,0]), 1):
    data = v.T[i,:] #Load correct weight trace data each round.
    fitsyn[i,:] = leastsq(residfunc, fitguess, args=(xdat,))[0]

#Calculate residuals and figure resulting variance in data.
for i in range(0, len(v.T[:,0])): #Sweep over synapses.
    data = v.T[i,:] #Load correct weight trace data each round.
    print('Residual STD for synapse ', i, ': ', np.std(residfunc(fitsyn[i,:], xdat))) #Extract STDs of the residuals.


#Plot weight evolution over time and show changes in weight as extracted from fittings.
print('Synapse:\tInitial w:\tFinal w:\tw diff:')

for i in range(len(v.T[:,0])): #Sweep over synapses.
    ax.plot(range(0,len(v.T[i,:]),1), v.T[i,:], label='Synapse '+str(i), color=col[i])
    ax.plot(xdat, fitfunc(fitsyn[i,:], xdat), label='Poly-fit '+str(i), lw=2.5, color=col[i])

    #Show overall change in weights over run as extracted from fittings.
    winit = fitfunc(fitsyn[i,:], 0)
    wend = fitfunc(fitsyn[i,:], len(v.T[i,:])-1)

    print('\t{:.4f}\t{:.4f}\t{:.4f}\t{:.4f}'.format(i, winit, wend, wend-winit))

ax.legend()


############################################################
# 3rd figure for plotting the FFT of the weight evolution. #
############################################################
if('FFT' in PANEL):
    fig3 = pl.figure(figsize=(fig_width['two_col'], cm2inch(10.)))
    rect = (0.08, 0.17, 0.85, 0.75)
    ax = fig3.add_axes(rect, aspect='auto')

    #Extract FFTs of weight evolutions.
    for i in range(len(v.T[:,0])):
        ax.plot(range(0,len(v.T[i,:]),1), np.abs(sc.fft(v.T[i,:])), label='Synapse '+str(i)) #Compute FT of weight evolution then take magnitude and plot.

    ax.legend()


####################################################################################
# 4th figure for plotting mebrane potential for both soft/hard synapses evolution. #
####################################################################################
if('membrane' in PANEL):
    fig4 = pl.figure(figsize=(fig_width['two_col'], cm2inch(20.)))
    rect1 = (0.08, 0.07, 0.85, 0.25)
    rect2 = (0.08, 0.45, 0.85, 0.50)

    #Plot 1: membrane potential evolution.
    ax = fig4.add_axes(rect2, aspect='auto')
    patterns_ = ['1001', '0110']

    # calculate the potentials
    nPat = len(reference_pattern)
    u = np.zeros((T,nPat))                   # membrane potential w/o biases
    us = np.zeros((T,nPat))                   # membrane potential w/o biases
    mempot = np.zeros((T,nPat))                   # membrane potential with biases: mempot[:][0] -> green, 1001, mempot[:][1] -> purple, 0110
    color = pattern_color
    dashes = (1,1)
    for j,pat in enumerate(reference_pattern):
        #Hardware synapses.
        u[:,j] = [np.dot(V[t,k_memristor], pat) for t in xrange(T)]
        # plot with biases
        mempot[:,j] = u[:,j] + B[:,k_memristor] #Capture full membrane potential including homeostatic bias.
        ax.plot(np.arange(T), mempot[:,j], '-', c=color[j], zorder=5, label='Hardware '+patterns_[j])
        # plot w/o biases
        #l, = ax.plot(np.arange(T), u[:,j], '--', c=color[j], zorder=4)
        #l.set_dashes(dashes)

        #Software synapses.
        us[:,j] = [np.dot(V[t,k_software], pat) for t in xrange(T)]
        # plot with biases
        mempot[:,j] = us[:,j] + B[:,k_software] #Capture full membrane potential including homeostatic bias.
        ax.plot(np.arange(T), mempot[:,j], '-', c=color[j+2], zorder=5, label='Software '+patterns_[j])
        # plot w/o biases
        #l, = ax.plot(np.arange(T), us[:,j], '--', c=color[j+2], zorder=4)
        #l.set_dashes(dashes)

    neurstring = ['hardware', 'software']
    for k in xrange(2): #Sweep over neurons.
        #Add homoeostatic bias on same panel.
        ax.plot(np.arange(T), B[:,k], '-', c=neuron_cols[k], zorder=5, lw=1.5, label='Hom. bias for '+neurstring[k])

    ax.plot(np.arange(T), [0]*len(np.arange(T)), '--') #x-axis.

    print('Max. homoeostatic term magnitude: ', np.max(B[:,k_memristor]), ' at ', np.where(B[:,k_memristor] == np.max(B[:,k_memristor])))
    print('Min. homoeostatic term magnitude: ', np.min(B[:,k_memristor]), ' at ', np.where(B[:,k_memristor] == np.min(B[:,k_memristor])))
    # adjust axes
    ymin, ymax = ax.yaxis.get_data_interval()
    delta = 0.07 * (ymax - ymin)
    ax.set_ylim(ymin-delta, ymax+delta)
    ymin, ymax = np.round(ax.get_ylim(), decimals=0)
    yticks = np.arange(ymin, ymax, 2)
    ax.set_yticks(yticks)
    ax.set_ylabel("U$_\mathrm{%d}$(y)" % k_memristor, labelpad=3)
    ax.set_xlim(-0.5, T-0.5)

    ax.legend()

    #2nd plot: homoeostatic bias.
    ax = fig4.add_axes(rect1, aspect='auto')

    for k in xrange(2): #Sweep over neurons.
        ax.plot(np.arange(T), B[:,k], '-', c=neuron_cols[k], zorder=5, label='Hom. bias for '+neurstring[k])

    ax.legend()


    #Compute basic numbers for assessing pattern preferences.
    avgsize = 20 #When computing average firing probability how many samples at the start and end of the membrane potential should be considered?
    #probstart = [0]*2 #INCORRECT: Cell is not in competition with itself for firing.
    #probend = [0]*2 #INCORRECT: Cell is not in competition with itself for firing.
    hardpotstart = [0]*2 #Hardware neuron membrane potential in response to 2 proto-patterns at the start/end of the ANN run.
    hardpotend = [0]*2
    
    for j in range(0, avgsize, 1):
        for i in range(0,2,1): #Sweep 2 prototype patterns.
            #Take first <x> samples.
            #probstart[i] += (np.exp(mempot[j][i]))/(np.sum(np.exp(mempot[j]))) #INCORRECT: Cell is not in competition with itself for firing.
            #probend[i] += (np.exp(mempot[-j-1][i]))/(np.sum(np.exp(mempot[-j-1]))) #INCORRECT: Cell is not in competition with itself for firing.
            hardpotstart[i] += mempot[j][i]/avgsize
            hardpotend[i] += mempot[-j-1][i]/avgsize

    #print(np.array(probstart)/avgsize, np.array(probend)/avgsize) #INCORRECT: Cell is not in competition with itself for firing.
    print('Start and end n-point average of calculated hardware neuron membrane potentials in response to patterns 1001 and 0110 ([start 1001, start 0110] [end 1001, end 0110]):')
    print(hardpotstart, hardpotend)

####################
# SHOW ALL FIGURES #
####################
pl.interactive(True)
datacursor()
pl.show()

# SAVE THE FIGURE
if SAVE:
    figname = fname[:-4] + "_figure_learning.png"
    print " > Save figure to '%s'." % figname
    fig.savefig(figname)

input() #Pause for user reaction.